//
//  PublicWifiViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 20.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PublicWifiViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
    
    @IBOutlet var tableView: UITableView!
    let orderCellIdentifier = "orderCell"
    var wifiOrders: [WifiBaseOrder] = []
    var device:Device?
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        configureBlueNavbar()
        addBackButtonForDefault(.whiteColor())
        localize()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        configureTableView()
        PKNotification.loading(true)
        requestPublicWifi()
    }
    
    func requestPublicWifi() {
        let params = [
            "access_token": Facade.accessToken!,
            "client_id": Facade.clientId!,
            "server_id": Facade.serverId!,
            "abonent_id": Facade.accountId!,
            "device": device!.device!
            ] as [String: AnyObject]
        PKNotification.loading(true)
        Facade.sharedInstance().getPublicWifi(params, onSuccess: { (wifiOrders) in
            self.wifiOrders = wifiOrders
            self.tableView.reloadData()
            }, onError: { (error) in
                AlertViewUtil.showIncorrectAlert(error)
            }, onFinish: {() in
                PKNotification.loading(false)
        })
    }
    
    private func configureTableView() {
        tableView.estimatedRowHeight = 150
        tableView.rowHeight = UITableViewAutomaticDimension
    }
}

// UITableViewDataSource
extension PublicWifiViewController {
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return wifiOrders.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier(orderCellIdentifier, forIndexPath: indexPath) as! PublicWifiOrderCell
        cell.fillCell(wifiOrders[indexPath.row], vc: self)
        return cell
    }
    
}

extension PublicWifiViewController {
    override var localizedId: String {
        return "public_wifi"
    }
}
