//
//  AdditionalStepper.swift
//  kt
//
//  Created by neox on 07.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class AdditionalStepper : UITableViewCell {
    
    @IBOutlet weak var labelTitle: UILabel!
    @IBOutlet weak var stepper: UIStepper!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelValue: UILabel!
    
    var value = 1
    var price = 900
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        stepper.value = 1
        update()
    }
    
    @IBAction func stepperChanged(sender: UIStepper) {
        value = Int(sender.value)
        update()
    }
    
    func update() {
        labelValue.text = String(value)
        labelPrice.text = String(value * price)
    }
    
    
}
