//
//  UIBaseTableViewCell.swift
//  kt
//
//  Created by Admin on 05.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class CellData {
    
    typealias DidSet = (currentValue:String?)->()
    typealias Observer = (DidSet)
    
    var observers = Dictionary<String, Observer>()
    
    internal var cellType : CellType {return CellType.TitleValueCell}
    var onClick : () -> Void = {}
    var onValidate : (AnyObject?) -> Bool = {_ in return true}
    
    func checkValues() -> Bool {
        return onValidate(nil)
    }
    
    func addObserver(identifier:String, observer:Observer){
        observers[identifier] = observer
    }
    
    func removeObserver(identifer:String){
        observers.removeValueForKey(identifer)
    }
    
    init() {
        
    }
    
}

class UIBaseTableViewCell : UITableViewCell {
    
    internal var cellData : CellData?
    
    internal func fillWithCellData(cellData : CellData) {
        self.cellData = cellData
    }
    
    internal func updateCellData() {
        
    }
    

    
}
