//
//  VIPMobileCell.swift
//  kt
//
//  Created by neox on 08.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation
import DLRadioButton

class VIPMobileCell : UITableViewCell {
    
    var vc : ServiceVIPTableViewController!
    var price = VIPPrices.VIP_MOBILE
    
    @IBOutlet weak var buttonPlus: UILabel!
    @IBOutlet weak var layoutHeader: UIView!
    @IBOutlet weak var buttonOption1: DLRadioButton!
    @IBOutlet weak var buttonOption2: DLRadioButton!
    @IBOutlet weak var buttonOption3: DLRadioButton!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelAudience: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    @IBOutlet weak var labelDescription1: UILabel!
    @IBOutlet weak var labelDescription2: UILabel!
    @IBOutlet weak var labelDescription3: UILabel!
    @IBOutlet weak var labelDescription4: UILabel!
    @IBOutlet weak var labelDescription5: UILabel!
    @IBOutlet weak var labelDescription6: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        //self.labelTitle.text = LS("service_vip_tv")
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        labelAudience.text = LS("service_vip_mobile_audience")
        labelUnit.text = LS("tenge_per_month")
        
        labelPrice.text = "+\(price)"
        buttonOption1.selected = true
        
        buttonOption1.setTitle(LS("service_vip_mobile_option_1"), forState: .Normal)
        buttonOption2.setTitle(LS("service_vip_mobile_option_2"), forState: .Normal)
        buttonOption3.setTitle(LS("service_vip_mobile_option_3"), forState: .Normal)
        
        labelDescription1.text = LS("service_vip_mobile_description_1")
        labelDescription2.text = LS("service_vip_mobile_description_2")
        labelDescription3.text = LS("service_vip_mobile_description_3")
        labelDescription4.text = LS("service_vip_mobile_description_4")
        labelDescription5.text = LS("service_vip_mobile_description_5")
        labelDescription6.text = LS("service_option")
        
    }
    
    override func setSelected(selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        if ( selected ) {
            self.contentView.layer.borderColor = UIColor.ocean().CGColor
            self.contentView.layer.borderWidth = 3
            layoutHeader.backgroundColor = UIColor.ocean()
            buttonPlus.textColor = UIColor.ocean()
        } else {
            self.contentView.layer.borderColor = UIColor.clearColor().CGColor
            self.contentView.layer.borderWidth = 0
            layoutHeader.backgroundColor = UIColor.sky()
            buttonPlus.textColor = UIColor.sky()
        }
        
    }
    
}
