//
//  CancelButton.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class CancelButton: UIButton {
    
    override func awakeFromNib() {
        super.awakeFromNib()
        setTitleColor(.whiteColor(), forState: UIControlState.Normal)
        setTitleColor(.whiteColor(), forState: UIControlState.Highlighted)
        setTitleColor(.whiteColor(), forState: UIControlState.Selected)
        setTitleColor(.whiteColor(), forState: UIControlState.Disabled)
        setTitleColor(.whiteColor(), forState: UIControlState.Reserved)
        self.backgroundColor = Color.AuthGrayNormalColor
        layer.cornerRadius = 7
    }
    
    override var highlighted: Bool {
        didSet {
            backgroundColor = highlighted ? Color.AuthGrayHighlightedColor : Color.AuthGrayNormalColor
        }
    }
}
