//
//  Bill.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class Bill {
  var reportDateId: Int?
  var type: String?
  var billDate: NSDate?
  var inMoney: String?
  var debit: String?
  var credit: String?
  var outMoney: String?
  var billPositions: [BillPos] = []
  
  init(json: JSON) {
    self.reportDateId = json["report_date_id"].int
    self.type = json["type"].string
    let dateFormatter = NSDateFormatter()
    dateFormatter.locale = NSLocale(localeIdentifier: "en_US_POSIX")
    dateFormatter.dateFormat = "dd-MM-yy"
    self.billDate = dateFormatter.dateFromString(json["bill_date"].stringValue)
    self.inMoney = json["in_money"].string
    self.debit = json["debit"].string
    self.credit = json["credit"].string
    self.outMoney = json["out_money"].string
    for item in json["bill_positions"].arrayValue {
      self.billPositions.append(BillPos(json: item))
    }
  }
  
  class BillPos {
    var billPosId: Int?
    var billPosName: String?
    var debit: Double?
    
    init(json: JSON) {
      self.billPosId = json["bill_pos_id"].int
      self.billPosName = json["bill_pos_name"].string
      self.debit = json["debit"].double
    }
  }

}
