//
//  KTWebViewController.swift
//  kt
//
//  Created by Admin on 09.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class KTWebViewController : UIViewController, UIWebViewDelegate {
    var url : String = ""
    var webView : UIWebView?
    var buttonBlue : UIButtonRoundedBlue?
    var isNeedShowCloseButton : Bool = false
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        configureBlueNavbar()
    }
    
    func showCloseButton() {
        isNeedShowCloseButton = true
    }
    
    func renderCloseButton() {
        /*buttonBlue = UIButtonRoundedBlue(frame: CGRect(x:5, y: 115, width: 300, height:54))
        buttonBlue!.titleLabel?.text = "Закрыть"
        buttonBlue!.addTarget(self, action: #selector(KTWebViewController.button_TouchUpInside(_:)), forControlEvents: UIControlEvents.TouchUpInside)
        self.webView!.addSubview(buttonBlue!)
        self.webView!.bringSubviewToFront(buttonBlue!)*/
        

        if (isNeedShowCloseButton) {
            let view = UIView()
            view.backgroundColor = UIColor.whiteColor()
            view.frame = CGRectMake(0, self.view.frame.size.height - 70, self.view.frame.size.width, self.view.frame.size.height - 70)
            let myFirstButton = UIButtonRoundedBlue()
            myFirstButton.setTitle("Закрыть", forState: .Normal)
            myFirstButton.titleLabel?.font = UIFont(name: "PTSans-Regular", size: 17)
            myFirstButton.setTitleColor(UIColor.whiteColor(), forState: .Normal)
            myFirstButton.frame = CGRectMake(8, 8, self.view.frame.size.width - 16, 54)
            myFirstButton.addTarget(self, action: #selector(KTWebViewController.button_TouchUpInside(_:)), forControlEvents: UIControlEvents.TouchUpInside)
        
            webView?.frame = CGRectMake(0, 0, (webView?.frame.size.width)!, ((webView?.frame.size.height)! - 70))
            view.addSubview(myFirstButton)
            self.view.addSubview(view)
            myFirstButton.highlighted = false

        }
    }
    
    init(fileWithName: String, ext: String) {
        super.init(nibName: nil, bundle: nil)
        //self.url = url
        var nsUrl = NSBundle.mainBundle().URLForResource(fileWithName, withExtension:ext)
        self.navigationController?.navigationBarHidden = false
        self.webView = UIWebView(frame: (self.view.frame))
        self.view.addSubview(webView!)
        self.webView!.scalesPageToFit = true
        self.webView!.delegate = self
        self.webView!.loadRequest(NSURLRequest(URL: nsUrl!))
        PKNotification.loading(true)
        self.renderCloseButton()
    }
    
    init(url : String)
    {
        super.init(nibName: nil, bundle: nil)
        self.url = url
        self.navigationController?.navigationBarHidden = false
        self.webView = UIWebView(frame: (self.view.frame))
        self.view.addSubview(webView!)
        self.webView!.scalesPageToFit = true
        self.webView!.delegate = self
        self.webView!.loadRequest(NSURLRequest(URL: NSURL(string: url)!))
        PKNotification.loading(true)
        self.renderCloseButton()
        //self.configureBlueNavbar()
    }
    
    @IBAction func button_TouchUpInside(sender: UIButton) {
        self.dismissViewControllerAnimated(true) { 
            
        }
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    /*convenience init(url : String) {
     
    }*/
    
    func webViewDidFinishLoad(webView: UIWebView) {
        self.renderCloseButton()
        PKNotification.loading(false)
    }
    
}
