//
//  RBCreationUneditableFieldTableCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class RBCreationUneditableFieldTableCell: UITableViewCell {
  @IBOutlet weak var label: UILabel!
  @IBOutlet weak var bottomLabel: UILabel!
  //  @IBOutlet weak var textField: UITextField!
  var vc: RBCreationViewController!
  var key: String!
  
  func fillCell(key: String, vc: RBCreationViewController) {
    self.vc = vc
    self.key = key
    label.setTextAndSizeToFit((LS("claim_page_menu.label.\(key)")).uppercaseString)
    label.textColor = Color.MyServicesCellGrayColor
    //    textField.delegate = vc
    fillTextField()
    
    //bottomLabel.setBottomBorder(Color.GrayTableCellSeparator)
  }
  
  func fillTextField() {
    switch key {
    case "device_number":
      bottomLabel.setTextAndSizeToFit("\(vc.selectedSiebelAccountData?.assetNumber ?? "") \(vc.selectedSiebelAccountData?.deviceGroupName ?? "")")
      break
    case "claim_type":
      bottomLabel.setTextAndSizeToFit(vc.currentDamageSource?.comments ?? "")
      break
    case "service":
      bottomLabel.setTextAndSizeToFit(vc.currentClaimSource?.typeValue ?? "")
      break
    case "treatment_type":
      bottomLabel.setTextAndSizeToFit(vc.currentClaimSubSource?.subTypeValue ?? "")
      break
    default:
      break
    }
    bottomLabel.text = bottomLabel.text?.uppercaseString
  }
}
