//
//  DynamicMenuManager.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.08.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class DynamicMenuManager {
    
    var feed : [FeedItem] = []
    var menu: [[String: AnyObject]] = []
    var loaded = false

    private init() {
        
    }
    
    class func sharedInstance() -> DynamicMenuManager {
        struct Shared {
            static let sharedInstance: DynamicMenuManager = DynamicMenuManager()
        }
        return Shared.sharedInstance
    }
    
    func getMenu(onComplete: (String?) -> Void) {
        Facade.sharedInstance().getMenuItems(CitiesManager.sharedInstance().userCity().id, onSuccess: { (menuData, feedData) in
            self.menu = menuData
            self.feed = feedData
            onComplete(nil)
            }, onError: { (error) in
                print(error)
                onComplete(error)
            }, onFinish: {
                
        })
    }
}
