//
//  FastPayManager.swift
//  kt
//
//  Created by Admin on 18.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation

class FastPayManager {
    
    //MARK: - Singletone Instance
    
    class func sharedInstance() -> FastPayManager {
        struct Shared {
            static let sharedInstance = FastPayManager()
        }
        return Shared.sharedInstance
    }
    
    //MARK: - Constructors
    
    private init() {
        
    }
    
    //MARK: - Functions
    func archiveFastPayItems(items:[FastPayItem]) -> NSData {
        let archivedObject = NSKeyedArchiver.archivedDataWithRootObject(items as NSArray)
        return archivedObject
    }
        
}

let UserDefaultsFastPayItemKey = "fastPays"
let UserDefaultsNeedCreatingInternalKey = "createdInternal"


//MARK: NSUserDefaults

extension FastPayManager {
    
    func getStoredFastPays() -> [FastPayItem] {
        var result : [FastPayItem] = []
        //createInternalFastPay()
        let storeresult = retrieveFastPays()
        if (storeresult != nil) {
            result = storeresult!
        }
        
        return result
    }
    
    func createInternalFastPay() {
        if (!isNeedCreatingInternalFastPay()) {
        var phoneNumber = SharedDataManager.sharedInstance().abonentPhoneNumber
        if phoneNumber.characters.count > 0 && !containsLetters(phoneNumber) {
            let index : String.Index = phoneNumber.startIndex.advancedBy(2)
            phoneNumber = phoneNumber.substringFromIndex(index)
            phoneNumber = phoneNumber.stringByReplacingOccurrencesOfString(" ", withString: "")
                let internalFastPay = FastPayItem(title: "мой номер", phoneNumber: phoneNumber)
                addInStoreFastPay(internalFastPay)
            }
            markAsCreatedInternalFastPay()
        }
    }
    
    func retrieveFastPays() -> [FastPayItem]? {
        if let unarchiveObject = NSUserDefaults.standardUserDefaults().objectForKey(UserDefaultsFastPayItemKey + UserManager.sharedInstance().login!) as? NSData {
            return NSKeyedUnarchiver.unarchiveObjectWithData(unarchiveObject) as? [FastPayItem]
        }
        return nil
    }
    
    func saveStoreFastPay(fastPays : [FastPayItem]) {
        let archivedItems = archiveFastPayItems(fastPays)
        NSUserDefaults.standardUserDefaults().setObject(archivedItems, forKey: UserDefaultsFastPayItemKey + UserManager.sharedInstance().login!)
        NSUserDefaults.standardUserDefaults().synchronize()
    }
    
    func addInStoreFastPay(fastPay : FastPayItem) {
        var items = retrieveFastPays()
        if (items == nil) {
            items = []
        }
        //removeFromStoreFastPay(fastPay)
        items!.append(fastPay)
        saveStoreFastPay(items!)
    }
    
    func removeFromStoreFastPay(fastPay : FastPayItem) {
        let items = getStoredFastPays()
        let mutableItems : NSMutableArray = NSMutableArray(array: items)
        for item in mutableItems {
            let fastPay2 = item as! FastPayItem
            if fastPay2.compare(fastPay) {
                mutableItems.removeObject(item)
                break
            }
        }
        saveStoreFastPay(mutableItems as! [FastPayItem])
    }
    
    func isNeedCreatingInternalFastPay() -> Bool {
        return NSUserDefaults.standardUserDefaults().boolForKey(UserDefaultsNeedCreatingInternalKey + UserManager.sharedInstance().login!)
    }
    
    func markAsCreatedInternalFastPay() {
        NSUserDefaults.standardUserDefaults().setBool(true, forKey: UserDefaultsNeedCreatingInternalKey + UserManager.sharedInstance().login!)
    }
    
}
