//
//  SubscribeMonth.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class SubscribeMonth {
  
  class Period {
    var name: String?
    var periodId: Int?
    
    init(json: JSON) {
      self.name = json["name"].string
      self.periodId = json["period_id"].int
    }
  }
  
  class Statistic {
    var serviceName: String?
    var totalInTraffic: Int?
    var totalOutTraffic: Int?
    var totalDebit: Int?
    
    init(json: JSON) {
      self.serviceName = json["service_name"].string
      self.totalInTraffic = json["total_in_traffic"].int
      self.totalOutTraffic = json["total_out_traffic"].int
      self.totalDebit = json["total_debit"].int
    }
  }
  
  var periods: [Period] = []
  var accountUserId: Int?
  var statistics: [Statistic] = []
  
  init(json: JSON) {
    for subJson in json["period"].arrayValue.reverse() {
      periods.append(Period(json: subJson))
    }
    self.accountUserId = json["account_user_id"].int
    for subJson in json["statistics"].arrayValue {
      self.statistics.append(Statistic(json: subJson))
    }
  }

}
