//
//  SpinneredAlert.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 12.09.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class SpinneredAlert {
    
    static func show(vc: UIViewController) {
        let alert = UIAlertController(title: nil, message: "\(LS("alert.please_wait"))\n\n\n", preferredStyle: .Alert)
        let spinner = UIActivityIndicatorView(activityIndicatorStyle: .WhiteLarge)
        spinner.center = CGPoint(x: 130.5, y: 65.5)
        spinner.color = .blackColor()
        spinner.startAnimating()
        alert.view.addSubview(spinner)
        vc.presentViewController(alert, animated: false, completion: nil)
    }
    
    static func dismiss(vc: UIViewController) {
        vc.dismissViewControllerAnimated(true, completion: nil)
    }
}
