//
//  RegistrationIntroViewController.swift
//  kt
//
//  Created by Admin on 09.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class RegistrationIntroViewController : StepViewController {
    
    //MARK : - IBOutlets
    
    @IBOutlet weak var lblTitle: UILabel!
    @IBOutlet weak var lblDescription: UILabel!
    @IBOutlet weak var btnGUIDAvailable: UIButtonRoundedBlue!
    @IBOutlet weak var btnGUIDNotAvailable: UIButtonRoundedBlue!
    
    
    //MARK: - Private functions
    
    func showFirstStepForm() {
        self.performSegueWithIdentifier("firstStep", sender: self)
    }
    
    func showCreateGUIDForm() {
        self.performSegueWithIdentifier("registrationGUIDIdentity", sender: self)
    }
    
    //MARK: - IBActions
    
    @IBAction func btnGUIDAvailable_clicked(sender: AnyObject) {
        showFirstStepForm()
    }
    
    @IBAction func btnGUIDNotAvailable_clicked(sender: AnyObject) {
        showCreateGUIDForm()
    }
    
    //MARK: - System
    
    override func viewDidLoad() {
        super.viewDidLoad()
        lblTitle.text = LS("registration_intro_lblTitle")
        lblDescription.text = LS("registration_intro_lblDescription")
        btnGUIDAvailable.titleLabel?.text = LS("registration_intro_btnGUIDAvailable")
        btnGUIDNotAvailable.titleLabel?.text = LS("registration_intro_btnGUIDNotAvailable")
    }
}













