//
//  OfferCallbackLinkCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OfferCallbackLinkCell : UITableViewCell {
  @IBOutlet weak var agreementLabel: UILabel!
  @IBOutlet weak var linkButton: UIButton!
  @IBOutlet weak var checkButton: NextButton!
  var vc: OffersCallbackViewController?
  var pay_touchUpInside: (() -> Void)?
  
  override func awakeFromNib() {
    super.awakeFromNib()
    checkButton.backgroundColor = Color.DashboardBlueColor
    localizeSubviews()
  }
  
  func fillCell(vc: OffersCallbackViewController) {
    self.vc = vc
  }
  
  private func localizeSubviews() {
    checkButton.setTitle(LS("offer_callback.button.send"), forState: .Normal)
  }
  
  @IBAction func checkButton_touchUpInside(sender: NextButton) {
    self.vc!.fillVarsFromTextViews()
    
    let request = OfferCallbackRequest(region: vc!.region?.name, regionType: vc!.region?.regionType, name: vc!.fullName, email: vc!.email, phone: vc!.phoneNumber, formType: "1")
    guard request.validateFields() else { AlertViewUtil.showAlert(request.validationMessage); return }
    Facade.sharedInstance().callbackSend(request.params, onSuccess: { (msg) in
      AlertViewUtil.showAlert(msg)
      }, onError: { (error) in
        AlertViewUtil.showErrorAlert(message: error)
      }) { 
        
    }
  }
  
  @IBAction func linkButton_touchUpInside(sender: UIButton) {
    //    vc!.performSegueWithIdentifier("callback", sender: nil)
  }
  
}

extension OfferCallbackLinkCell: LocalizedParent {
  var localizedId: String {
    return "offer_callback"
  }
}
