//
//  WiFiCell.swift
//  kt
//
//  Created by Alexander Zalutskiy on 25.02.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class WiFiCell: UITableViewCell {
  override func setSelected(selected: Bool, animated: Bool) {
    super.setSelected(selected, animated: animated)
    
    let block : () -> Void = {
      if selected {
        self.textLabel?.textColor = UIColor.whiteColor()
        self.detailTextLabel?.textColor = UIColor.whiteColor()
      } else {
        self.textLabel?.textColor = Color.DarkColorForText
        self.detailTextLabel?.textColor = Color.DarkColorForText
      }
    }
    
    if (animated) {
      UIView.animateWithDuration(0.2, animations: block)
    } else {
      block()
    }
  }
  
  override func setHighlighted(highlighted: Bool, animated: Bool) {
    super.setHighlighted(highlighted, animated: animated)
    
    let block : () -> Void = {
      if highlighted {
        self.textLabel?.textColor = UIColor.whiteColor()
        self.detailTextLabel?.textColor = UIColor.whiteColor()
      } else {
        self.textLabel?.textColor = Color.DarkColorForText
        self.detailTextLabel?.textColor = Color.DarkColorForText
      }
    }
    
    if (animated) {
      UIView.animateWithDuration(0.2, animations: block)
    } else {
      block()
    }
  }
}