//
//  Facade+Bot.swift
//  kt
//
//  Created by neox on 12.07.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//
import Foundation

extension Facade {
    
    func askBot(text: String?, onSuccess: (BotResult) -> Void, onError: (error: String) -> Void) {
        let headers = ["Content-Type" : "application/x-www-form-urlencoded"]
        let params = ["request" : text!]
        request(.POST, "https://telecom.kz/api/bot/ask.json", parameters: params, headers: headers, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                if let nodes = json["nodes"].array {
                    var botNodes : [BotNode] = []
                    for n in nodes {
                        let botNode = BotNode()
                        botNode.id = n["id"].string
                        botNode.parentId = n["parent_id"].string
                        botNode.linkTo = n["link_to"].string
                        botNode.formId = n["form_id"].string
                        botNode.text = n["text"].string
                        botNode.expanded = n["expanded"].int
                        botNode.isLink = n["isLink"].int
                        botNode.entityId = n["entity_id"].string
                        botNode.type = n["type"].string
                        botNodes.append(botNode)
                    }
                    let res = BotResult()
                    res.nodes = botNodes;
                    res.status = json["status"].string
                    res.count = json["count"].int
                    onSuccess(res)
                }
            }
        })
    }
    
    func childBot(id: String?, onSuccess: (BotResult) -> Void, onError: (error: String) -> Void) {
        let headers = ["Content-Type" : "application/x-www-form-urlencoded"]
        let params = ["id" : id!]
        request(.POST, "https://telecom.kz/api/bot/children.json", parameters: params, headers: headers, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                if let nodes = json["nodes"].array {
                    var botNodes : [BotNode] = []
                    for n in nodes {
                        let botNode = BotNode()
                        botNode.id = n["id"].string
                        botNode.parentId = n["parent_id"].string
                        botNode.linkTo = n["link_to"].string
                        botNode.formId = n["form_id"].string
                        botNode.text = n["text"].string
                        botNode.expanded = n["expanded"].int
                        botNode.isLink = n["isLink"].int
                        botNode.entityId = n["entity_id"].string
                        botNode.type = n["type"].string
                        botNodes.append(botNode)
                    }
                    let res = BotResult()
                    res.nodes = botNodes;
                    res.status = json["status"].string
                    res.count = json["count"].int
                    onSuccess(res)
                }
            }
        })
    }
    
    func getBalanceByPhone(phone: String, onSuccess: (String) -> Void, onError: (error: String) -> Void) {
        request(.GET, "https://telecom.kz/api/payment/get_balance.json?phone=\(phone)", parameters: nil, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                if let balance = json["balance"].float {
                    onSuccess(String(balance))
                } else {
                    onError(error: "Error")
                }
            }
        })
    }
    
    func getBalanceByGuid(guid: String, onSuccess: (String) -> Void, onError: (error: String) -> Void) {
        request(.GET, "https://telecom.kz/api/payment/get_balance.json?guid=\(guid)", parameters: nil, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                if let balance = json["balance"].float {
                    onSuccess(String(balance))
                } else {
                    onError(error: "Error")
                }
            }
        })
    }
}
