//
//  City.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 26.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import CoreLocation

let UserDefaultsCity = "UserDefaultsCity"

class City : Equatable {
  var id: Int
  var name: String
  var location: CLLocationCoordinate2D?
  
  init(json: JSON) {
    if let id = json["id"].int {
      self.id = id
    }
    else {
      self.id = json["city_id"].intValue
    }
    name = json["name"].stringValue
  }
  
  init(dictionary: [String : AnyObject]) {
    id = dictionary["id"] as! Int
    name = dictionary["name"] as! String
  }
  
  func getDictionary() -> [String : AnyObject] {
    var dict = [String : AnyObject]()
    dict["id"] = id
    dict["name"] = name
    return dict
  }
  
  func setLocation(coord : CLLocationCoordinate2D) {
    location = coord
  }
  
  func setLat(lat : Double, andLng lng: Double) {
    location = CLLocationCoordinate2D(latitude: lat, longitude: lng)
    
    
  }
}

func ==(lhs: City, rhs: City) -> Bool {
  if lhs.id == rhs.id {
    return true
  }
  return false
}