//
//  Validator.swift
//  kt
//
//  Created by neox on 23.06.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class Validator: NSObject {
    
    static func isValidAbonentID(testStr:String) -> Bool {
        let emailRegEx = "^\\d{4,16}$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluateWithObject(testStr)
    }
    
    static func isValidEmail(testStr:String) -> Bool {
        let emailRegEx = "^[\\w!#$%&’*+/=?`{|}~^-]+(?:\\.[\\w!#$%&’*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluateWithObject(testStr)
    }
    
    static func isValidRegisterCode(testStr:String) -> Bool {
        let emailRegEx = "^\\d{8,24}$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluateWithObject(testStr)
    }
    
    static func isValidLogin(testStr:String) -> Bool {
        let emailRegEx = "^[a-zA-Z][a-zA-Z0-9-_\\.]{5,16}$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluateWithObject(testStr)
    }
    
    static func isValidPassword(testStr:String) -> Bool {
        let emailRegEx = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])[0-9a-zA-Z@$!%*#?&]{8,12}$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluateWithObject(testStr)
    }
    
    static func isValidIin(testStr:String) -> Bool {
        let emailRegEx = "^([0-9]{2})(0[1-9]|1[012])([1-9]|0[1-9]|[1-2][0-9]|3[0-1])([3-6])([0-9]{5})?$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        return emailTest.evaluateWithObject(testStr)
    }
}
