//
// Created by Alexander Zalutskiy on 06.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class RegistrationViewController: UIViewController {
  // MARK: Labels

  @IBOutlet private weak var _descriptionLabel: UILabel!
  @IBOutlet private weak var _guidDescriptionLabel: UILabel!
  @IBOutlet private weak var _guidCodeLabel: UILabel!
  @IBOutlet private weak var _registrationCodeLabel: UILabel!
  @IBOutlet private weak var _fieldsDescriptionLabel: UILabel!
  @IBOutlet private weak var _fieldsDescriptionLabel2: UILabel!
  @IBOutlet private weak var _loginLabel: UILabel!
  @IBOutlet private weak var _passwordLabel: UILabel!
  @IBOutlet private weak var _retryPasswordLabel: UILabel!
  @IBOutlet private weak var _mobilePhoneLabel: UILabel!
  @IBOutlet private weak var _emailLabel: UILabel!
  @IBOutlet private weak var _questionLabel: UILabel!
  @IBOutlet private weak var _answerLabel: UILabel!
  @IBOutlet private weak var _advertisingLabel: UILabel!
  @IBOutlet private weak var _smsLabel: UILabel!

  // MARK: Text Fields

  @IBOutlet private weak var _guidPart1TextField: UITextField!
  @IBOutlet private weak var _guidPart2TextField: UITextField!
  @IBOutlet private weak var _registrationCodeTextField: UITextField!
  @IBOutlet private weak var _loginTextField: UITextField!
  @IBOutlet private weak var _passwordTextField: UITextField!
  @IBOutlet private weak var _retryPasswordTextField: UITextField!
  @IBOutlet private weak var _mobilePhoneTextField: UITextField!
  @IBOutlet private weak var _emailTextField: UITextField!
  @IBOutlet private weak var _answerTextField: UITextField!

  // MARK: Buttons

  @IBOutlet private weak var _questionButton: UIButton!
  @IBOutlet private weak var _signUpButton: UIButton!
  @IBOutlet private weak var _helpButton: UIButton!

  // MARK: View life cycle

  override func viewDidLoad() {

    navigationItem.leftBarButtonItem = UIBarButtonItem(title: §"cancel", style: .Plain, target: self,
        action: #selector(RegistrationViewController.hide(_:)))

    let textFields = [
        _guidPart1TextField,
        _guidPart2TextField,
        _registrationCodeTextField,
        _loginTextField,
        _passwordTextField,
        _retryPasswordTextField,
        _mobilePhoneTextField,
        _emailTextField,
        _answerTextField,
    ]

    for textField in textFields {
      textField.applyUITextFieldStyle()
    }

    _questionButton.applyUITextFieldStyle()

    super.viewDidLoad()
  }


  override func viewWillAppear(animated: Bool) {
    localizeSubviews()

    super.viewWillAppear(animated)
  }

  // MARK: Action

  func hide(sender: AnyObject?) {
    dismissViewControllerAnimated(true, completion: nil)
  }

  // MARK: Localize

  func localizeSubviews() {
    _descriptionLabel.text = §"registration.label.description"
    _guidDescriptionLabel.text = §"registration.label.guid_description"
    _guidCodeLabel.text = (§"registration.label.guid").uppercaseString
    _registrationCodeLabel.text = (§"registration.label.registration_code").uppercaseString
    _fieldsDescriptionLabel.text = §"registration.label.fields_description"
    _fieldsDescriptionLabel2.text = §"registration.label.fields_description_2"
    _loginLabel.text = (§"registration.label.login").uppercaseString
    _passwordLabel.text = (§"registration.label.password").uppercaseString
    _retryPasswordLabel.text = (§"registration.label.retry_password").uppercaseString
    _mobilePhoneLabel.text = (§"registration.label.mobile_phone").uppercaseString
    _emailLabel.text = (§"registration.label.email").uppercaseString
    _questionLabel.text = (§"registation.label.question").uppercaseString
    _answerLabel.text = (§"registration.label.answer").uppercaseString
    _advertisingLabel.text = (§"registration.label.advertising").uppercaseString
    _smsLabel.text = (§"registration.label.sms").uppercaseString

    _emailTextField.placeholder = §"registration.text_field.email.placeholder"
    _answerTextField.placeholder = §"registration.text_field.answer.placeholder"

    _questionButton.setTitle(§"registration.button.question", forState: .Normal)
    _signUpButton.setTitle(§"registration.button.sign_up", forState: .Normal)
    _helpButton.setTitle(§"registration.button.help", forState: .Normal)
  }
}
