//
//  SelectCityForProviderViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class SelectCityForProviderViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
  @IBOutlet var tableView: UITableView!
  let reuseCellIdentifier = "cell"
  var vc: ProvidersViewController?
  
  override func viewDidLoad() {
    super.viewDidLoad()
    if UIDevice.currentDevice().userInterfaceIdiom == .Pad {
      addBackButtonForDefault(.whiteColor())
    } else {
      addBackButtonForModal(.whiteColor())
    }
    configureBlueNavbar()
    configureTableView()
  }
  
  private func configureTableView() {
    tableView.rowHeight = UITableViewAutomaticDimension
    tableView.estimatedRowHeight = 60
  }
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    //    localize()
    tableView.reloadData()
  }
}

// UITableViewDataSource
extension SelectCityForProviderViewController {
  
  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return vc!.providersWrapper!.cities.count + 1
  }
  
  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier(reuseCellIdentifier, forIndexPath: indexPath) as! SelectCityForProviderCell
    cell.fillCell(vc!.providersWrapper!.cities[indexPath.row].name!)
    //cell.selectionStyle = .None
    return cell
  }
}

// UITableViewDelegate
extension SelectCityForProviderViewController {
  func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
    vc!.selectedLocationId = vc!.providersWrapper!.cities[indexPath.row].id!
    if UIDevice.currentDevice().userInterfaceIdiom == .Pad {
      back()
    } else {
      dismissViewControllerAnimated(false, completion: nil)
    }
    //    self.vc?.dismissViewControllerAnimated(true, completion: nil)
    //    self.navigationController?.popViewControllerAnimated(true)
    //    dismissViewControllerAnimated(false, completion: nil)
  }
}

extension SelectCityForProviderViewController {
  override var localizedId: String {
    return "select_city_for_provider"
  }
}
