//
//  PublishedCashInfoCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PublishedCashInfoCell : UITableViewCell {
  @IBOutlet weak var dateLabel: UILabel!
  @IBOutlet weak var typeLabel: UILabel!
  @IBOutlet weak var leftCashNumberLabel: UILabel!
  @IBOutlet weak var rightCashNumberLabel: UILabel!
  @IBOutlet weak var leftInMoneyLabel: UILabel!
  @IBOutlet weak var rightInMoneyLabel: UILabel!
  @IBOutlet weak var leftDebitLabel: UILabel!
  @IBOutlet weak var rightDebitLabel: UILabel!
  @IBOutlet weak var leftCreditLabel: UILabel!
  @IBOutlet weak var rightCreditLabel: UILabel!
  @IBOutlet weak var leftOutMoneyLabel: UILabel!
  @IBOutlet weak var rightOutMoneyLabel: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    self.removeLeftMargin()
    leftCashNumberLabel.textColor = Color.DarkColorForText
    rightCashNumberLabel.textColor = Color.DarkColorForText
    leftInMoneyLabel.textColor = Color.DarkColorForText
    rightInMoneyLabel.textColor = Color.DarkColorForText
    leftDebitLabel.textColor = Color.DarkColorForText
    rightDebitLabel.textColor = Color.DarkColorForText
    leftCreditLabel.textColor = Color.DarkColorForText
    rightCreditLabel.textColor = Color.DarkColorForText
    leftOutMoneyLabel.textColor = Color.DarkColorForText
    rightOutMoneyLabel.textColor = Color.DarkColorForText
  }
  
  func fillCell(bill: Bill) {
    localizeSubviews()
    dateLabel.text = bill.billDate == nil ? LS("published_cashes.label.no_date") : bill.billDate!.getWithFormat("dd.MM.yy")
    typeLabel.text = bill.type
    rightCashNumberLabel.text = "\(bill.reportDateId!)"
    rightInMoneyLabel.text = bill.inMoney
    rightDebitLabel.text = bill.debit
    rightCreditLabel.text = bill.credit
    rightOutMoneyLabel.text = bill.outMoney
  }
  
  private func localizeSubviews() {
    leftCashNumberLabel.localizeWithParent(self, localizedId: "cash_number")
    leftInMoneyLabel.localizeWithParent(self, localizedId: "in_money")
    leftDebitLabel.localizeWithParent(self, localizedId: "debit")
    leftCreditLabel.localizeWithParent(self, localizedId: "credit")
    leftOutMoneyLabel.localizeWithParent(self, localizedId: "out_money")
  }
  
}

extension PublishedCashInfoCell: LocalizedParent {
  var localizedId: String {
    return "published_cashes"
  }
}
