//
//  MyServicesCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 08.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class MyServicesCell: UITableViewCell {
  @IBOutlet var titleLabel: UILabel!
  @IBOutlet var typeLabel: UILabel!
  @IBOutlet var numberLabel: UILabel!
    
    internal var url : String!
    

  override func awakeFromNib() {
    super.awakeFromNib()
    titleLabel.textColor = Color.AuthBlueNormalColor
    typeLabel.textColor = Color.MyServicesCellGrayColor
    numberLabel.textColor = Color.MyServicesCellGrayColor
    removeLeftMargin()
  }
  
  func fillCell(device: Device) {
    titleLabel.text = device.deviceGroupName
    //if (device.type != .Megogo) {
        typeLabel.text = device.tariffPlanName
        numberLabel.text = device.device
    //}
    if device.type != .TypeHasNoSettings || device.type == .Megogo || device.type == .IDTV {
        self.accessoryType = .DisclosureIndicator
    } else {
        self.accessoryType = .None
    }
  }
  
}
