//
//  UIView+ResizeView.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 27.01.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

extension UIView {
  
  func resizeToFitSubviews() {
    
    let subviewsRect = subviews.reduce(CGRect.zero) {
      $0.union($1.frame)
    }
    
    let fix = subviewsRect.origin
    subviews.forEach {
      $0.frame.offsetInPlace(dx: -fix.x, dy: -fix.y)
    }
    
    frame.offsetInPlace(dx: fix.x, dy: fix.y)
    frame.size = subviewsRect.size
  }
  
}
