//
//  Facade+Pss.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 28.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

let FacadePssPointsSuccess = "FacadePssPointsSuccess"

extension Facade {
  
  func getPssPointsForCityId(id : Int) {
    request(Router.PssPointsForCity(id)).responseSwiftyJSON {
      (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
      } else {
        Router.globalLog.debug(resp)
      }
      
      var points = [Pss]()
      
      for (_, subJson) in json {
        points.append(Pss(json: subJson))
      }
      
      self.notificationCenter.postNotificationName(
        FacadePssPointsSuccess,
        object: self,
        userInfo: ["points" : points]
      )
    }
  }
  
  func getPssPointsForCity(city : City) {
    getPssPointsForCityId(city.id)
  }
  
}
