//
//  Facade+Registration.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 08.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
    func register(onSuccess: () -> Void, onError: String -> Void, onFinish: () -> Void) {
        
        var params = [String: AnyObject]()
        AbonentForRegister.sharedInstance()
        
        //    "IN_ADV":1
        //    "IN_ABONENT_ID":123456,
        //    "IN_MOBILE":"7171654321",
        //    "IN_SERVER_ID":17,
        //    "IN_CODE_WORD":"123abc",
        //    "IN_EMAIL":"email@mail.ru",
        //    "IN_LOGIN":"LOGIN",
        //    "IN_PASSWORD":"password",
        //    "IN_SMS":0,
        //    "IN_CONTROL_QUESTION":"Кипелов?",
        //    "IN_CONTROL_ANSWER":"Валерий"
        
        let par = [AbonentForRegister.sharedInstance().inAdv, AbonentForRegister.sharedInstance().inAbonentId,
                   AbonentForRegister.sharedInstance().inMobile, AbonentForRegister.sharedInstance().inServerId,
                   AbonentForRegister.sharedInstance().inCodeWord, AbonentForRegister.sharedInstance().inEmail,
                   AbonentForRegister.sharedInstance().inLogin, AbonentForRegister.sharedInstance().inPassword,
                   AbonentForRegister.sharedInstance().inSms, AbonentForRegister.sharedInstance().inControlQuestion,
                   AbonentForRegister.sharedInstance().inControlAnswer]
        
        let forPrint = "IN_ADV: \(par[0]) \n IN_ABONENT_ID: \(par[1]) \n" +
            "IN_MOBILE: \(par[2]) \n IN_SERVER_ID: \(par[3]) \n" +
            "IN_CODE_WORD: \(par[4]) \n IN_EMAIL: \(par[5]) \n" +
            "IN_LOGIN: \(par[6]) \n IN_PASSWORD: \(par[7]) \n" +
            "IN_SMS: \(par[8]) \n IN_CONTROL_QUESTION: \(par[9]) \n IN_CONTROL_ANSWER: \(par[10])"
        print(forPrint)
        
        params["IN_ADV"] = AbonentForRegister.sharedInstance().inAdv
        params["IN_ABONENT_ID"] = AbonentForRegister.sharedInstance().inAbonentId
        params["IN_MOBILE"] = AbonentForRegister.sharedInstance().inMobile
        params["IN_SERVER_ID"] = AbonentForRegister.sharedInstance().inServerId
        params["IN_CODE_WORD"] = AbonentForRegister.sharedInstance().inCodeWord
        params["IN_EMAIL"] = AbonentForRegister.sharedInstance().inEmail
        params["IN_LOGIN"] = AbonentForRegister.sharedInstance().inLogin
        params["IN_PASSWORD"] = AbonentForRegister.sharedInstance().inPassword
        params["IN_SMS"] = AbonentForRegister.sharedInstance().inSms
        params["IN_CONTROL_QUESTION"] = AbonentForRegister.sharedInstance().inControlQuestion
        params["IN_CONTROL_ANSWER"] = AbonentForRegister.sharedInstance().inControlAnswer
        
        request(Router.Register(params)).responseSwiftyJSON { (req, resp, json, error) -> Void in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            guard let errorCode = json["error_code"].int else {
                print("some error")
                return
            }
            if errorCode == 3 {
                if let errorMessage = json["error"].string {
                    Router.globalLog.error(errorMessage)
                    onError(errorMessage)
                }
            } else if errorCode == 0 {
                onSuccess()
            }
            if let error = error {
                Router.globalLog.error(error)
                print(error)
            } else {
                Router.globalLog.debug(resp)
            }
            onFinish()
        }
    }
}
