//
//  FullDamageModalTableCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class FullDamageModalTableCell: UITableViewCell {
  @IBOutlet weak var leftLabel: UILabel!
  @IBOutlet weak var rightLabel: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    removeLeftMargin()
    leftLabel.textColor = Color.BlueButtonColor
    rightLabel.textColor = Color.DarkColorForText
  }
  
  func fillCell(key: String, fullDamage: FullDamage? = nil, claim: Claim? = nil, tabIndex: Int) {
    switch key {
    case "id":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.id"))
      if tabIndex == 0 {
        rightLabel.setTextAndSizeToFit(fullDamage?.damageId ?? "")
      } else {
        rightLabel.setTextAndSizeToFit(claim?.claimId ?? "")
      }
      break
    case "device_id":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.device_id"))
      if tabIndex == 0 {
        rightLabel.setTextAndSizeToFit("\(fullDamage?.assetNumber ?? "") \(fullDamage?.deviceGroup ?? "")")
      } else {
        rightLabel.setTextAndSizeToFit(claim?.assetNumber ?? "")
      }
      break
    case "created":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.created"))
      if tabIndex == 0 {
        rightLabel.setTextAndSizeToFit(fullDamage?.date ?? "")
      } else {
        rightLabel.setTextAndSizeToFit(claim?.date ?? "")
      }
      break
    case "claim_type":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.claim_type"))
      rightLabel.setTextAndSizeToFit(fullDamage?.complaintName ?? "")
      break
    case "pretension_type":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.pretension_type"))
      rightLabel.setTextAndSizeToFit(claim?.claimTypeName ?? "")
      break
    case "comment":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.comment"))
      rightLabel.setTextAndSizeToFit(claim?.comments ?? "")
      break
    case "claimer":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.applicant"))
      rightLabel.setTextAndSizeToFit(fullDamage?.applicantName)
      break
    case "status":
      leftLabel.setTextAndSizeToFit(LS("full_damage_modal.label.status"))
      if tabIndex == 0 {
        rightLabel.setTextAndSizeToFit(fullDamage?.status ?? "")
      } else {
        rightLabel.setTextAndSizeToFit(claim?.status ?? "")
      }
      break
    default:
      break
    }
  }
  
}
