//
//  OfferCallbackFieldCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OfferCallbackFieldCell : UITableViewCell, UITextFieldDelegate {
  @IBOutlet weak var titleLabel: UILabel!
  @IBOutlet weak var textField: UITextField!
  var vc: OffersCallbackViewController!
  var textValue = ""
    var lblPrefix: UILabel?
  var clickableCellValue: String = notClickableCell {
    didSet {
      if clickableCellValue == clickableCell {
        self.accessoryType = .DisclosureIndicator
      } else {
        //self.selectionStyle = .None
        self.accessoryType = .None
      }
    }
  }
  
    internal func RenderPrefix() {
        if (lblPrefix != nil && textField.text?.characters.count == 0) {
            lblPrefix?.textColor = Color.PlaceholderGrayColor
        } else {
            ShowPrefixAsBlackColor()
        }
    }
    
    internal func ShowPrefixAsBlackColor() {
        lblPrefix?.textColor = Color.TitleBlackColor
    }

    
    func fillDefaultValue() {
        if (textValue.characters.count > 0 && vc.params.count > 0) {
            let value = vc.params[textValue]
            if (value != nil) {
                textField.text = value as? String
            }
        }
    }

    
  override func awakeFromNib() {
    super.awakeFromNib()
    textField.addTarget(self, action: #selector(OfferCallbackFieldCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
    textField.applyUITextFieldStyle()
  }
  
  func textChanged(textField: UITextField) {
    vc.params[textValue] = textField.text
  }
  
  func cellSelected(vc: OffersCallbackViewController, title: String) {
    vc.performSegueWithIdentifier("showOfferModal", sender: title)
  }
  
  func fillCellForCallback(text: String, vc: OffersCallbackViewController) {
    textValue = text
    self.vc = vc
    textField.delegate = self.vc
    titleLabel.localizeWithParent(self, localizedId: text)
    switch text {
    case "full_name":
      textField.placeholder = LS("offer_callback.text_field.full_name.placeholder")
      break
    case "phone":
      lblPrefix = KeyboardUtil.changeKeyboardType(.PhonePad, textField: self.textField, leftViewRightMargin: 3)
      self.textField.delegate = self;
      RenderPrefix()
      break
    case "city":
      textField.text = vc.region?.name
      textField.userInteractionEnabled = false
      break
    case "email":
      textField.placeholder = "Email"
      break
    default:
      break
    }
  }
  
  func fillCell(text: String, vc: OffersCallbackViewController, clickableCellValue: String) {
    self.clickableCellValue = clickableCellValue
    self.vc = vc
    textField.delegate = self.vc
    textValue = text
    titleLabel.localizeWithParent(self, localizedId: text)
    titleLabel.text = titleLabel.text?.uppercaseString
    switch text {
    case "full_name":
      textField.placeholder = LS("offer_callback.text_field.full_name.placeholder")
      break
    case "phone":
      lblPrefix = KeyboardUtil.changeKeyboardType(.PhonePad, textField: self.textField, leftViewRightMargin: 3)
      //self.textField.delegate = self;
      RenderPrefix()
      break
    case "city":
      textField.text = vc.region?.name
      textField.userInteractionEnabled = false
      break
    default:
      break
    }
  }
}

// UITextFieldDelegate
extension OfferCallbackFieldCell {
    
  func textFieldShouldReturn(textField: UITextField) -> Bool {
    self.endEditing(true)
    return false
  }
}

extension OfferCallbackFieldCell: LocalizedParent {
  var localizedId: String {
    return "offer_callback"
  }
}

