//
//  Swif.swift
//  kt
//
//  Created by neox on 10.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

//class VIPGamer : UITableViewCell {
//
//    var vc : ServiceVIPTableViewController!
//    var price = 2000
//    
//    override func awakeFromNib() {
//        super.awakeFromNib()
//        
//    }
//    
//}

class VIPGamer: UITableViewCell {
    
    var vc: ServiceVIPTableViewController!
    var price = VIPPrices.VIP_GAMER
    
    @IBOutlet weak var layoutHeader: UIView!
    @IBOutlet weak var buttonPlus: UILabel!
    @IBOutlet weak var labelService: UILabel!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelAudience: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    @IBOutlet weak var labelOption1: UILabel!
    @IBOutlet weak var labelOption2: UILabel!
    @IBOutlet weak var labelOption3: UILabel!
    @IBOutlet weak var labelDescription1: UILabel!
    @IBOutlet weak var labelDescription2: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        labelService.text = LS("service_vip_gamer")
        labelPrice.text = "+\(price)"
        labelAudience.text = LS("service_vip_gamer_audience")
        labelUnit.text = LS("tenge_per_month")
        
        labelDescription1.text = LS("service_vip_gamer_description_1")
        labelDescription2.text = LS("service_vip_gamer_description_2")
        
        labelOption1.text = LS("service_vip_gamer_option_1")
        labelOption2.text = LS("service_vip_gamer_option_2")
        labelOption3.text = LS("service_vip_gamer_option_3")
    }
    
    override func setSelected(selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        if ( selected ) {
            self.contentView.layer.borderColor = UIColor.ocean().CGColor
            self.contentView.layer.borderWidth = 3
            layoutHeader.backgroundColor = UIColor.ocean()
            buttonPlus.textColor = UIColor.ocean()
        } else {
            self.contentView.layer.borderColor = UIColor.clearColor().CGColor
            self.contentView.layer.borderWidth = 0
            layoutHeader.backgroundColor = UIColor.sky()
            buttonPlus.textColor = UIColor.sky()
        }
    }
    
}
