//
//  UIButton+Util.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 29.10.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

extension UIButton {
  
  public override func intrinsicContentSize() -> CGSize {
    
    let intrinsicContentSize = super.intrinsicContentSize()
    
    let adjustedWidth = intrinsicContentSize.width + titleEdgeInsets.left + titleEdgeInsets.right
    let adjustedHeight = intrinsicContentSize.height + titleEdgeInsets.top + titleEdgeInsets.bottom
    
    return CGSize(width: adjustedWidth, height: adjustedHeight)
    
  }
  
}
