//
//  UITableView+UI.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

extension UITableView {
  func addTopLine() {
    let px = 1 / UIScreen.mainScreen().scale
    let frame = CGRectMake(0, 0, self.frame.size.width, px)
    let line: UIView = UIView(frame: frame)
    self.tableHeaderView = line
    line.backgroundColor = self.separatorColor
  }
  
  public override func awakeFromNib() {
    super.awakeFromNib()
    self.tableFooterView = UIView(frame: CGRectZero)
  }
}
