//
//  UIView+Util.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 29.10.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

extension UIView {
  func applyUITextFieldStyle() {
    let bottomLayer = CALayer()
    bottomLayer.frame = CGRect(x: 0.0, y: bounds.height - 1.0,
                               width: bounds.width, height: 1.0)
    bottomLayer.backgroundColor = Color.TextFieldUnderline.CGColor
    
    layer.addSublayer(bottomLayer)
    
    if let textField = self as? UITextField {
      let lView = UIView(frame: CGRect(x: 0.0, y: 0.0, width: 5.0, height: bounds.height))
      textField.leftView = lView
      textField.leftViewMode = .Always
    }
  }
}
