//
//  UIViewController+KTDesign.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 01.02.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

extension UIViewController {
    
    func setBackButton() {
        let backButton1 = backButton()
        backButton1.addTarget(self, action: #selector(UIViewController.popViewController(_:)), forControlEvents: .TouchUpInside)
        navigationItem.leftBarButtonItem = UIBarButtonItem(customView: backButton1)
        navigationController!.interactivePopGestureRecognizer!.delegate = ScreenEdgePanGestureRecognizerForBugFix.sharedInstance()
    }
    
    private func backButton() -> UIButton {
        let backButton = UIButton(frame: CGRect(x: 0, y: 0, width: 70, height: 40))
        backButton.setTitle(LocalizedString("back", description: LS("back")), forState: .Normal)
        backButton.setTitleColor(Color.DarkColorForText, forState: .Normal)
        backButton.setTitleColor(Color.BlueColorForHighlighted, forState: .Highlighted)
        backButton.setImage(
            UIImage(named: "navbar_back_icon_normal")!.imageWithRenderingMode(.AlwaysOriginal),
            forState: .Normal
        )
        backButton.setImage(
            UIImage(named: "navbar_back_icon_tap")!.imageWithRenderingMode(.AlwaysOriginal),
            forState: .Highlighted
        )
        backButton.titleLabel!.font = UIFont(name: "PTSans-Regular", size: 17)
        backButton.contentHorizontalAlignment = .Left
        backButton.contentEdgeInsets = UIEdgeInsets(top: 0, left: -10, bottom: 0, right: 0)
        backButton.titleEdgeInsets = UIEdgeInsets(top: 0, left: 4, bottom: 0, right: 0)
        
        return backButton
    }
    
    func processRequest(enabled: Bool) {
        PKNotification.loading(enabled)
        self.view.userInteractionEnabled = !enabled
        if (navigationController != nil) {
            self.navigationController!.view.userInteractionEnabled = !enabled
            self.navigationController!.navigationBar.userInteractionEnabled = !enabled
            
        }
        if (self.view != nil && self.view.window != nil) {
            self.view.window!.userInteractionEnabled = !enabled;
        }
    }
    
    func popViewController(sender: AnyObject) {
        navigationController!.popViewControllerAnimated(true)
    }
    
    func setRightTextButton(text: String, target: AnyObject?, selector: Selector, color: UIColor? = nil, highlightedColor: UIColor? = nil) {
        let backButton = UIButton(frame: CGRect(x: 0, y: 0, width: 100, height: 40))
        backButton.setTitle(text, forState: .Normal)
        backButton.setTitleColor(color ?? Color.DarkColorForText, forState: .Normal)
        backButton.setTitleColor(highlightedColor ?? Color.BlueColorForHighlighted, forState: .Highlighted)
        backButton.titleLabel!.font = UIFont(name: "PTSans-Regular", size: 17)
        backButton.contentHorizontalAlignment = .Right
        backButton.addTarget(target, action: selector, forControlEvents: .TouchUpInside)
        
        navigationItem.rightBarButtonItem = UIBarButtonItem(customView: backButton)
    }
    
    func configureGrayNavbar() {
        //    Color.GrayNavbarColor
        self.navigationController?.navigationBar.setBackgroundImage(UIImage(), forBarPosition: UIBarPosition.Any, barMetrics: UIBarMetrics.Default)
        self.navigationController?.navigationBar.shadowImage = UIImage()
        self.navigationController?.navigationBar.barTintColor = Color.GrayNavbarColor
        self.navigationController?.navigationBar.barStyle = UIBarStyle.Black
        //    self.navigationController?.navigationBar.tintColor = nil
        self.navigationController?.navigationBar.tintColor = .whiteColor()
        navigationController?.navigationBar.setBottomBorderColor(UIColor.blackColor(), height: 0)
        self.navigationController?.navigationBar.translucent = false
        self.navigationItem.titleView?.tintColor = Color.DarkColorForText
    }
    
    func configureBlueNavbar() {
        self.navigationController?.navigationBar.setBackgroundImage(UIImage(), forBarPosition: UIBarPosition.Any, barMetrics: UIBarMetrics.Default)
        self.navigationController?.navigationBar.shadowImage = UIImage()
        self.navigationController?.navigationBar.barTintColor = Color.DashboardBlueColor
        self.navigationController?.navigationBar.barStyle = UIBarStyle.Black
        self.navigationController?.navigationBar.tintColor = UIColor.whiteColor()
        self.navigationController?.navigationBar.setBottomBorderColor(UIColor.whiteColor(), height: 0)
        self.navigationController?.navigationBar.translucent = false
        self.navigationItem.titleView?.tintColor = UIColor.whiteColor()
        self.navigationController?.WhiteLabel()
    }
}

class ScreenEdgePanGestureRecognizerForBugFix : NSObject, UIGestureRecognizerDelegate {
    class func sharedInstance() -> ScreenEdgePanGestureRecognizerForBugFix {
        struct Shared {
            static let sharedInstance : ScreenEdgePanGestureRecognizerForBugFix = ScreenEdgePanGestureRecognizerForBugFix()
        }
        return Shared.sharedInstance
    }
    
    func gestureRecognizer(
        gestureRecognizer: UIGestureRecognizer,
        shouldRecognizeSimultaneouslyWithGestureRecognizer otherGestureRecognizer:UIGestureRecognizer) -> Bool {
        return true
    }
    
    func gestureRecognizer(
        gestureRecognizer: UIGestureRecognizer,
        shouldBeRequiredToFailByGestureRecognizer otherGestureRecognizer:UIGestureRecognizer) -> Bool
    {
        return gestureRecognizer.isKindOfClass(UIScreenEdgePanGestureRecognizer)
    }
}
