//
// Created by Alexander Zalutskiy on 12.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
    
    struct AbonentInfoNotificationNames {
        static let Success = "AbonentInfoSuccess"
        static let Error = "AbonentInfoError"
    }
    
    func getAbonentInfo() {
        
        if Facade.serverId == nil || Facade.accountId == nil {
            
            getGuid(self.getAbonentInfo)
            
        } else {
            
            let parameters = [
                "access_token": Facade.accessToken!,
                "client_id": Facade.clientId!,
                "server_id": Facade.serverId!,
                "abonent_id": Facade.accountId!,
                ] as [String: AnyObject]
            
            request(.POST, "https://telecom.kz/api/guid/get_abonent_info.json", parameters: parameters, encoding: .JSON).responseJSON(completionHandler: { (resp) in
                Router.globalLog.debug(resp.request!)
                switch resp.result {
                case .Failure(let error):
                    Router.globalLog.error(error.debugDescription)
                    self.notificationCenter.postNotificationName(AbonentInfoNotificationNames.Error, object: self, userInfo: [
                        FacadeNotificationErrorKey: error,
                        ])
                case .Success(let json):
                    Router.globalLog.debug(resp.response!)
                    Router.globalLog.debug(json)
                    let abonentInfo = AbonentInfo(dict: json as! [String : AnyObject])
                    self.notificationCenter.postNotificationName(AbonentInfoNotificationNames.Success, object: self, userInfo: [
                        FacadeNotificationObjectKey: abonentInfo,
                        ])
                    
                    //          Router.globalLog.debug(FacadeError.ParsingObject)
                    //          self.notificationCenter.postNotificationName(AbonentInfoNotificationNames.Error, object: self, userInfo: [
                    //            FacadeNotificationErrorKey: FacadeError.ParsingObject,
                    //            ])
                }
            })
        }
    }
}
