//
//  Facade+ServicesPayments.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 29.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
  func getProviders(params: [String: AnyObject], onSuccess: (ProvidersWrapper) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.GetProviders(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else {
          let providersWrapper = ProvidersWrapper(json: json)
          onSuccess(providersWrapper)
        }
      }
    })
  }
  
  func mythPost(params: [String: AnyObject], onSuccess: (String) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.MythPost(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else {
          print("mythPost: \(json)")
          onSuccess("")
        }
      }
    })
  }
  
  func getCardAndBankTypes(params: [String: AnyObject], onSuccess: ([String: [BankAndCard]]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.GetCardAndBankTypes(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else {
          var cardBank: [BankAndCard] = []
          if let jsonArray = json["card_bank"].array {
            for subJson in jsonArray {
              cardBank.append(BankAndCard(json: subJson))
            }
          }
          var cardType: [BankAndCard] = []
          if let jsonArray = json["card_type"].array {
            for subJson in jsonArray {
              cardType.append(BankAndCard(json: subJson))
            }
          }
          onSuccess(["card_bank": cardBank, "card_type": cardType])
        }
      }
    })
  }
  
}
