//
//  BannersManager.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 31.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

let BannersManagerUpdate = "BannersManagerUpdate"

class BannersManager {
	private var _banners = [Banner]()
	
	private let notificationCenter = NSNotificationCenter.defaultCenter()
	
	class func sharedInstance() -> BannersManager {
		struct Shared {
			static let sharedInstance = BannersManager()
		}
		return Shared.sharedInstance
	}
	
	private init() {
		
	}
	
	func setBanners(banners : JSON) {
		_banners = [Banner]()
		
		for (_, subJson) in banners {
			_banners.append(Banner(json: subJson))
		}
		
		notificationCenter.postNotificationName(BannersManagerUpdate, object: self)
	}
	
	func getBanners() -> [Banner] {
		return _banners
	}
}