//
//  GetTargetingListRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 31.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class GetTargetingListRequest {
  var listType: String?
  var regionId: String?
  var areaId: String?
  var cityId: String?
  var streetId: String?
  var villageId: String?
  
  init(listType: String? = nil, regionId: String? = nil, areaId: String? = nil, cityId: String? = nil, streetId: String? = nil, villageId: String? = nil) {
    self.listType = listType
    self.regionId = regionId
    self.areaId = areaId
    self.cityId = cityId
    self.streetId = streetId
    self.villageId = villageId
  }
  
//  func validateFields() -> Bool {
//    var isValid = true
//    if accessToken.isNilOrEmpty || clientId.isNilOrEmpty || serverId == nil || abonentId.isNilOrEmpty || oldPassword.isNilOrEmpty || newPassword.isNilOrEmpty || newPasswordRepeat.isNilOrEmpty {
//      isValid = false
//    }
//    if oldPassword == "" || newPassword == "" || newPassword != newPasswordRepeat {
//      isValid = false
//    }
//    return isValid
//  }
  
  var params: [String: AnyObject] {
    var params = [String: AnyObject]()
    if let listType = listType {
      params["list_type"] = listType
    }
    if let regionId = regionId {
      params["region_id"] = regionId
    }
    if let areaId = areaId {
      params["area_id"] = areaId
    }
    if let cityId = cityId {
      params["city_id"] = cityId
    }
    if let streetId = streetId {
      params["street_id"] = streetId
    }
    if let villageId = villageId {
      params["village_id"] = villageId
    }
    return params
  }

}
