//
//  SubscribePeriod.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class SubscribePeriod {
  class Traffic {
    var serviceInfo: String?
    var acctoutputoctest: Int?
    var acctinputoctets: Int?
    var debit: Int?
    
    init(json: JSON) {
      self.serviceInfo = json["service_info"].string
      self.acctoutputoctest = json["acctoutputoctest"].int
      self.acctinputoctets = json["acctinputoctets"].int
      self.debit = json["debit"].int
    }
  }
  
  class Total {
    var serviceName: String?
    var totalInTraffic: Int?
    var totalOutTraffic: Int?
    var totalDebit: Int?
    
    init(json: JSON) {
      self.serviceName = json["service_name"].string
      self.totalInTraffic = json["total_in_traffic"].int
      self.totalOutTraffic = json["total_out_traffic"].int
      self.totalDebit = json["total_debit"].int
    }
  }
  
  var traffics: [Traffic] = []
  var totalList: [Total] = []
  
  
  init(json: JSON) {
    for subJson in json["list_traffic"].arrayValue {
      self.traffics.append(Traffic(json: subJson))
    }
    for subJson in json["total_list"].arrayValue {
      self.totalList.append(Total(json: subJson))
    }
  }
  
}
