//
//  Claim.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 17.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class Claim {
    var claimId: String?
    var status: String?
    var statusId: String?
    var assetNumber: String?
    var date: String?
    var claimTypeId: String?
    var claimTypeName: String?
    var claimKindId: String?
    var claimKindName: String?
    var comments: String?
    var decision: String?
    var claimNumber: String?
    var endDate: String?
    var cancel: String?
    var cancelDate: String?
    var markName: String?
    var markDate: String?
    var addInfo: AddInfo?
    
    class AddInfo {
        var count: String?
        var number: String?
        
        init(json: JSON) {
            self.count = json["count"].stringValue
            self.number = json["number"].stringValue
        }
    }
    
    func isCanceled() -> Bool {
        return (cancelDate?.characters.count > 0 || endDate?.characters.count > 0) ? true : false
    }
    
    init(json: JSON) {
        self.claimId = json["claim_id"].string
        self.status = json["status"].string
        self.statusId = json["status_id"].string
        self.assetNumber = json["asset_number"].string
        self.date = json["date"].string
        self.claimTypeId = json["claim_type_id"].string
        self.claimTypeName = json["claim_type_name"].string
        self.claimKindId = json["claim_kind_id"].string
        self.claimKindName = json["claim_kind_name"].string
        self.comments = json["comments"].string
        self.decision = json["decision"].string
        self.claimNumber = json["claim_number"].string
        self.endDate = json["end_date"].string
        self.cancel = json["cancel"].string
        self.cancelDate = json["cancel_date"].string
        self.markName = json["mark_name"].string
        self.markDate = json["mark_date"].string
        self.addInfo = AddInfo(json: json["add_info"])
    }
}
