//
//  SiebelAccount.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 17.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class SiebelAccount {
  var dataDict: [String: SiebelAccountData] = [String: SiebelAccountData]()
  var siebelAccountDataList: [SiebelAccountData] = []
  init(json: JSON) {
    if let dict = json.dictionary {
      for (key, value) in dict {
        dataDict[key] = SiebelAccountData(json: value)
        siebelAccountDataList.append(SiebelAccountData(json: value))
      }
    }
    //    siebelAccountDataList.sortInPlace { (el1, el2) -> Bool in
    //    }
  }
  
class SiebelAccountData : ListBoxItemProtocol {
    var accountNumber: String?
    var accountTypeName: String?
    var assetId: String?
    var assetNumber: String?
    var deviceGroupName: String?
    
    
     @objc var listItemTitle : String {
            get{
                return ("\(self.assetNumber ?? "") \(self.deviceGroupName ?? "")").uppercaseString
            }
        }
        
        
    init(json: JSON) {
      self.accountNumber = json["account_number"].string
      self.accountTypeName = json["accountTypeName"].string
      self.assetId = json["asset_id"].string
      self.assetNumber = json["asset_number"].string
      self.deviceGroupName = json["device_group_name"].string
    }
        
        
        
  }
}
