//
//  ProvidersWrapper.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 29.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ProvidersWrapper {
  var requestId: String?
  var sessionPayRequest: String?
  var providers: [Provider] = []
  var cities: [ProviderCity] = []
  
  //  var cities: [] = []
  init(json: JSON) {
    //  "requestId": "55dc53e20770c",
    //  "session_pay_request": "d854b9f4-8f3b-4914-a6f9-7ca62ec35913",
    //  "providers": [
    self.requestId = json["requestId"].string
    self.sessionPayRequest = json["session_pay_request"].string
    for subJson in json["providers"].arrayValue {
      self.providers.append(Provider(json: subJson))
    }
    for subJson in json["cities"].arrayValue {
      self.cities.append(ProviderCity(json: subJson))
    }
    if cities.count > 0 {
      cities.insert(ProviderCity(id: -1, name: LS("providers.label.all_points")), atIndex: 0)
    }
  }
  
  class ProviderCity {
    var id: Int?
    var name: String?
    
    init(id: Int? = nil, name: String? = nil) {
      self.id = id
      self.name = name
    }
    
    init(json: JSON) {
      if let stringedId = json["id"].string, let intId = Int(stringedId) {
        self.id = intId
      }
      self.name = json["name"].string
    }
    
  }
  
  class Provider {
    var logo: String?
    var category: String?
    var contractname: String?
    var name: String?
    var parameter: String?
    var contractformat: String?
    var contractregexp: String?
    var contractmask: String?
    var locationId: Int?
    
    init(name: String?) {
      self.name = name
    }
    
    init(json: JSON) {
      self.logo = json["logo"].string
      self.category = json["category"].string
      self.contractname = json["contractname"].string
      self.name = json["name"].string
      self.parameter = json["parameter"].string
      self.contractformat = json["contractformat"].string
      self.contractregexp = json["contractregexp"].string
      self.contractmask = json["contractmask"].string
      self.locationId = json["locationId"].int
    }
    
  }
  
  //  "requestId": "55dc53e20770c",
  //  "session_pay_request": "d854b9f4-8f3b-4914-a6f9-7ca62ec35913",
  //  "providers": [
  //  {
  //  "logo": "host_kz.png",
  //  "category": "TV и Internet",
  //  "contractname": "Email",
  //  "name": "Host.kz",
  //  "parameter": "HOST_KZ"
  //  },
  //  {
  //  "logo": "KCELL.png",
  //  "category": "Сотовая и спутниковая связь",
  //  "name": "KCell",
  //  "contractformat": "Kcell 701xxxxxxx, 702xxxxxxx, 775xxxxxxx или 778xxxxxxx",
  //  "contractregexp": "^((701)|(702)|(775)|(778))([\\d]{7})$",
  //  "contractmask": "+7 (\\7##) ###-##-##",
  //  "contractname": "Мобильный телефон",
  //  "parameter": "KCELL"
  //  },
}
