//
//  WiFi.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 28.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import CoreLocation
import MapKit

func convertDistance(distance: Int) -> (km: Int, m: Int) {
  return (distance / 1000, distance % 1000)
}

class WiFi : NSObject {
  var id: Int
  var name : String
  var address: String
  
  var distance: Int?
  
  var _coordinate: CLLocationCoordinate2D
  
  var cityId : Int
  var desc : String
  
  init(json : JSON) {
    id = json["id"].intValue
    name = json["name"].stringValue
    _coordinate = CLLocationCoordinate2D(latitude: json["lat"].doubleValue, longitude: json["lng"].doubleValue)
    desc = json["description"].stringValue
    cityId = json["city_id"].intValue
    address = json["address"].stringValue
  }
}

extension WiFi: MKAnnotation {
  
  var coordinate : CLLocationCoordinate2D {
    get {
      return _coordinate
    }
  }
  
  var title : String? {
    return name
  }
  
  var subtitle: String? {
    return address
  }
  
  func setCoordinate(newCoordinate: CLLocationCoordinate2D) {
    _coordinate = newCoordinate
  }
}