//
//  ChangeCreditLimitRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 29.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ChangeCreditLimitRequest {
  var accessToken: String?
  var clientId: String?
  var serverId: Int?
  var abonentId: String?
  var limit: String?
  var inAccountUserId: String?
  
  init(accessToken: String, clientId: String, serverId: Int, abonentId: String, limit: String?, inAccountUserId: String?) {
    self.accessToken = accessToken
    self.clientId = clientId
    self.serverId = serverId
    self.abonentId = abonentId
    self.limit = limit
    self.inAccountUserId = inAccountUserId
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if accessToken.isNilOrEmpty || clientId.isNilOrEmpty || serverId == nil || abonentId.isNilOrEmpty || limit.isNilOrEmpty || inAccountUserId.isNilOrEmpty {
      isValid = false
    }
    if let limit = limit where Double(limit) == nil {
      isValid = false
    }
    return isValid
  }
  
  var params: [String: AnyObject] {
    return ["access_token": self.accessToken!,
            "client_id": self.clientId!,
            "server_id": self.serverId!,
            "abonent_id": self.abonentId!,
            "limit": self.limit ?? "",
            "in_account_user_id": self.inAccountUserId ?? ""]
  }
}
