//
//  GetTariffPlanChangeHistoryRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 06.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class GetTariffPlanChangeHistoryRequest {
  var accessToken: String?
  var clientId: String?
  var serverId: Int?
  var abonentId: Int?
  var limit: Int?
  var inAccountUserId: Int?
  
  init(accessToken: String?, clientId: String?, serverId: Int?, abonentId: Int?, limit: Int?, inAccountUserId: Int?) {
    self.accessToken = accessToken
    self.clientId = clientId
    self.serverId = serverId
    self.abonentId = abonentId
    self.limit = limit
    self.inAccountUserId = inAccountUserId
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if accessToken.isNilOrEmpty || clientId.isNilOrEmpty || serverId == nil || abonentId == nil || inAccountUserId == nil || limit == nil {
      isValid = false
    }
    return isValid
  }
  
  var params: [String: AnyObject] {
    return ["access_token": self.accessToken!,
            "client_id": self.clientId!,
            "server_id": self.serverId!,
            "abonent_id": self.abonentId!,
            "in_account_user_id": self.inAccountUserId!,
            "limit": limit!]
  }

}
