//
//  MythPostRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class MythPostRequest {
  //  "access_token": "BIXBAFOTUH",
  //  "client_id": "109b7cb2d0",
  //  "server_id": 17,
  //  "abonent_id":2504653,
  //  "email":"k8839@yandex.ru",
  //  "session_pay_request":     "8d85d6d5-021a-4e64-8b27-af5f57e0fe1d",
  //  "requestId": "55d2fc4aeb183",
  //  "provider":"HOST_KZ",
  //  "phone": "705456777",
  //  "amount": "500",
  //  "cardType": "VISA",
  //  "bank": "kaspi"
  
  var accessToken: String?
  var clientId: String?
  var serverId: Int?
  var abonentId: Int?
  var email: String?
  var session_pay_request: String?
  var requestId: String?
  var provider: String?
  var phone: String?
  var amount: String?
  var cardType: String?
  var bank: String?
  
  
  init(accessToken: String? = nil, clientId: String? = nil, serverId: Int? = nil, abonentId: Int? = nil, email: String? = nil, session_pay_request: String? = nil, requestId: String? = nil, provider: String? = nil, phone: String? = nil, amount: String? = nil, cardType: String? = nil, bank: String? = nil) {
    self.accessToken = accessToken
    self.clientId = clientId
    self.serverId = serverId
    self.abonentId = abonentId
    self.email = email
    self.session_pay_request = session_pay_request
    
    self.requestId = requestId
    self.provider = provider
    self.phone = phone
    self.amount = amount
    self.cardType = cardType
    self.bank = bank
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if accessToken.isNilOrEmpty || clientId == nil || serverId == nil || phone.isNilOrEmpty || email.isNilOrEmpty || session_pay_request.isNilOrEmpty || requestId.isNilOrEmpty || provider.isNilOrEmpty || phone.isNilOrEmpty || amount.isNilOrEmpty || cardType.isNilOrEmpty || bank.isNilOrEmpty {
      isValid = false
    }
    return isValid
  }
  
  var params: [String: AnyObject] {
    let params = ["access_token": accessToken!,
                  "client_id": clientId!,
                  "server_id": serverId!,
                  "abonent_id":abonentId!,
                  "email":email!,
                  "session_pay_request": session_pay_request!,
                  "requestId": requestId!,
                  "provider":provider!,
                  "phone": phone!,
                  "amount": amount!,
                  "cardType": cardType!,
                  "bank": bank!]
    return params as! [String : AnyObject]
  }
  
}
