//
//  AlertViewUtil.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 11.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class AlertViewUtil {
    
    static func showMessageAlert(message: String, vc: UIViewController) {
        let alertController = UIAlertController(title: "", message: message ?? LS("error"), preferredStyle: UIAlertControllerStyle.Alert)
        alertController.addAction(UIAlertAction(title: "Ok", style: .Cancel, handler: nil))
        vc.presentViewController(alertController, animated: true, completion: nil)
    }
    
    static func showMessageAlert(message: String, vc: UIViewController, handler:() -> Void) {
        let alertController = UIAlertController(title: "", message: message ?? LS("error"), preferredStyle: UIAlertControllerStyle.Alert)
        alertController.addAction(UIAlertAction(title: "Ok", style: .Cancel, handler: { (alertAction) in
            handler()
            }
            ))
        vc.presentViewController(alertController, animated: true, completion: nil)
    }
    
    static func showErrorAlert(message: String, vc: UIViewController) {
        let alertController = UIAlertController(title: LS("error"), message: message, preferredStyle: UIAlertControllerStyle.Alert)
        alertController.addAction(UIAlertAction(title: "Ok", style: .Cancel, handler: nil))
        vc.presentViewController(alertController, animated: true, completion: nil)
    }
    
    static func showErrorAlert(title: String = LS("error"), message: String? = nil, vc: UIViewController, handler:() -> Void) {
        let alertController = UIAlertController(title: title, message: message, preferredStyle: .Alert)
        alertController.addAction(UIAlertAction(title: "Ok", style: .Cancel, handler: { (alertAction) in
            handler()
            }
            ))
        vc.presentViewController(alertController, animated: true, completion: nil)
    }
    
    static func showIncorrectAlert(message: String? = LS("login.label.incorrect_data")) {
        let msg = message?.stringByReplacingOccurrencesOfString("OUTMSG:", withString: "")
        let alertView = UIAlertView(title: msg!, message: nil, delegate: nil, cancelButtonTitle: LocalizedString("login.button.close"))
        alertView.show()
    }
    
    static func showAlert(message: String = "") {
        let alertView = UIAlertView(title: message, message: nil, delegate: nil, cancelButtonTitle: LS("login.button.close"))
        alertView.show()
    }
    
    static func showErrorAlert(title: String = LS("error"), message: String? = nil) {
        let alertView = UIAlertView(title: title, message: message, delegate: nil, cancelButtonTitle: LS("login.button.close"))
        alertView.show()
    }
    
}
