//
//  StoryboardFetchable.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

protocol StoryboardFetchable {
  static var storyboardId: String { get }
}

extension StoryboardFetchable where Self: UIViewController {
  static func fromStoryboard(storyboard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)) -> Self {
    return storyboard.instantiateViewControllerWithIdentifier(storyboardId) as! Self
  }
}
