//
//  ViewControllerCustomTitle.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 19.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class ViewControllerWithCustomTitle : KeyboardedViewController {
    
    var navigationBarTitle : String = "" {
        didSet {
            titleLabel?.text = navigationBarTitle
        }
    }
    
    var titleColor: UIColor = Color.DarkColorForText
    
    private var titleLabel : UILabel?
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        titleLabel = UILabel(frame: CGRect(x: 0, y: 0, width: 150, height: 36))
        titleLabel!.textColor = titleColor
        titleLabel!.text = navigationBarTitle
        titleLabel!.textAlignment = .Center
        titleLabel!.font = NavigationBarFont
        self.navigationItem.titleView = titleLabel
    }
    
}
