//
//  KnowedgeQuestionsViewController.swift
//  kt
//
//  Created by neox on 14.09.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class KnowedgeQuestionsViewController: UIViewController {
    
    var id : Int = 0
    var screenName : String?
    var answersList : [AnswerModel] = []
    
    @IBOutlet weak var tableview: UITableView!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        self.navigationItem.title = screenName
        
        self.tableview.estimatedRowHeight = 44.0;
        self.tableview.rowHeight = UITableViewAutomaticDimension;
        self.tableview.separatorStyle = .None
        
        Facade.sharedInstance().getAnswers({ (answersList : [AnswerModel]) in
            self.answersList = answersList
            self.tableview.reloadData()
            }, onError: { (error : String) in
                AlertViewUtil.showErrorAlert(error, vc: self)
            }, onFinish: {
                
            }, categoryID: id)
        
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return answersList.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("Cell", forIndexPath: indexPath) as! QuestionKnowedgeTableViewCell
        cell.question.text = answersList[indexPath.row].question
        cell.answer.text = answersList[indexPath.row].answer
        return cell
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
}
