//
//  TariffPlanChangeHistoryViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.10.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class TariffPlanChangeHistoryViewController: UIViewController, UITableViewDataSource {
  @IBOutlet weak var noDataLabel: UILabel!
  @IBOutlet weak var tableView: UITableView!
  var tariffPlans: [TariffPlanChangeHistory] = []
  
  func configureViews() {
    configureBlueNavbar()
    addBackButtonForModal(.whiteColor())
    noDataLabel.textColor = Color.DarkColorForText
    self.view.bringSubviewToFront(noDataLabel)
  }
  
  override func viewDidLoad() {
    super.viewDidLoad()
    configureViews()
    if tariffPlans.isEmpty {
      tableView.hidden = true
      self.noDataLabel.hidden = false
      self.noDataLabel.setTextAndSizeToFit(LS("no_data"))
    }
  }
}

// UITableViewDataSource
extension TariffPlanChangeHistoryViewController {
  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier("cell", forIndexPath: indexPath) as! TariffPlanChangeHistoryCell
    let resultString = "\(tariffPlans[indexPath.row].packetTypeName ?? "") \(tariffPlans[indexPath.row].systemDate?.getWithFormat("dd.MM.yyyy") ?? "") \(tariffPlans[indexPath.row].operation ?? "")"
    cell.label.setTextAndSizeToFit(resultString)
    //cell.selectionStyle = .None
    return cell
  }
  
  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return tariffPlans.count
  }
}
