//
//  OfferSelectCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 31.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OfferSelectCell : UITableViewCell {
  @IBOutlet weak var label: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    removeLeftMargin()
    label.textColor = Color.DarkColorForText
//    contentView.backgroundColor = Color.DashboardBlueColor
  }
  
  func fillCell(item: String) {
    label.text = item
  }
  
}


extension OfferSelectCell: LocalizedParent {
  var localizedId: String {
    return "offers_select_list"
  }
}
